/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsComplianceConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsQueryParser;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.EvaluatedDlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.LegacyRoleBasedDocumentAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.filter.DlsFilterLevelActionHandler;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class DlsFlsValve
implements SyncAuthorizationFilter {
    private static final String MAP_EXECUTION_HINT = "map";
    private static final Logger log = LogManager.getLogger(DlsFlsValve.class);
    private final Client nodeClient;
    private final ClusterService clusterService;
    private final GuiceDependencies guiceDependencies;
    private final ThreadContext threadContext;
    private final Mode mode;
    private final DlsQueryParser dlsQueryParser;
    private final IndexNameExpressionResolver resolver;
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final boolean localHashingEnabled;

    public DlsFlsValve(Settings settings, Client nodeClient, ClusterService clusterService, IndexNameExpressionResolver resolver, GuiceDependencies guiceDependencies, NamedXContentRegistry namedXContentRegistry, ThreadContext threadContext, ConfigurationRepository configurationRepository, AtomicReference<DlsFlsProcessedConfig> config, DlsFlsComplianceConfig complianceConfig) {
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.guiceDependencies = guiceDependencies;
        this.threadContext = threadContext;
        this.mode = Mode.get(settings);
        this.dlsQueryParser = new DlsQueryParser(namedXContentRegistry);
        this.config = config;
        this.localHashingEnabled = complianceConfig.isLocalHashingEnabled();
    }

    public SyncAuthorizationFilter.Result apply(PrivilegesEvaluationContext context, ActionListener<?> listener) {
        SearchSourceBuilder source;
        boolean doFilterLevelDls;
        EvaluatedDlsFlsConfig evaluatedDlsFlsConfig;
        DlsFlsProcessedConfig config = this.config.get();
        if (!config.isEnabled()) {
            return SyncAuthorizationFilter.Result.OK;
        }
        this.blockAccessInCaseOfRoleOrMappingsConfigurationErrors();
        User user = context.getUser();
        ImmutableSet mappedRoles = context.getMappedRoles();
        String action = context.getAction().name();
        ActionRequest request = (ActionRequest)context.getRequest();
        ActionRequestIntrospector.ResolvedIndices resolved = context.getRequestInfo().getResolvedIndices();
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = context.getSpecialPrivilegesEvaluationContext();
        if (this.threadContext.getHeader("_sg_filter_level_dls_done") != null) {
            if (log.isDebugEnabled()) {
                log.debug("DLS is already done for: " + this.threadContext.getHeader("_sg_filter_level_dls_done"));
            }
            return SyncAuthorizationFilter.Result.OK;
        }
        if (log.isDebugEnabled()) {
            log.debug("DlsFlsValveImpl.invoke()\nrequest: " + request + "\nresolved: " + resolved + "\nmode: " + (Object)((Object)this.mode));
        }
        LegacyRoleBasedDocumentAuthorization documentAuthorization = config.getDocumentAuthorization();
        if (specialPrivilegesEvaluationContext != null && specialPrivilegesEvaluationContext.getRolesConfig() != null) {
            SgDynamicConfiguration roles = context.getSpecialPrivilegesEvaluationContext().getRolesConfig();
            documentAuthorization = new LegacyRoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roles, this.resolver, this.clusterService);
        }
        try {
            evaluatedDlsFlsConfig = documentAuthorization.getDlsFlsConfig(user, (ImmutableSet<String>)mappedRoles, null);
        }
        catch (PrivilegesEvaluationException e) {
            log.error("Error while evaluating DLS/FLS configuration", (Throwable)e);
            throw new ElasticsearchSecurityException("Error while evaluating DLS/FLS configuration", (Exception)((Object)e), new Object[0]);
        }
        if (evaluatedDlsFlsConfig == null || evaluatedDlsFlsConfig.isEmpty() || resolved == null) {
            return SyncAuthorizationFilter.Result.OK;
        }
        EvaluatedDlsFlsConfig filteredDlsFlsConfig = evaluatedDlsFlsConfig.filter(resolved);
        if (this.mode == Mode.FILTER_LEVEL) {
            doFilterLevelDls = true;
        } else if (this.mode == Mode.LUCENE_LEVEL) {
            doFilterLevelDls = false;
        } else {
            Mode modeByHeader = this.getDlsModeHeader();
            if (modeByHeader == Mode.FILTER_LEVEL) {
                doFilterLevelDls = true;
                log.debug("Doing filter-level DLS due to header");
            } else {
                doFilterLevelDls = this.dlsQueryParser.containsTermLookupQuery(filteredDlsFlsConfig.getAllQueries());
                if (doFilterLevelDls) {
                    this.setDlsModeHeader(Mode.FILTER_LEVEL);
                    log.debug("Doing filter-level DLS because query contains TLQ");
                } else {
                    log.debug("Doing lucene-level DLS because query does not contain TLQ");
                }
            }
        }
        if (!doFilterLevelDls) {
            this.setDlsHeaders(evaluatedDlsFlsConfig, request);
        }
        this.setFlsHeaders(evaluatedDlsFlsConfig, request);
        if (filteredDlsFlsConfig.isEmpty()) {
            return SyncAuthorizationFilter.Result.OK;
        }
        if (request instanceof RealtimeRequest) {
            ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
        }
        if (request instanceof SearchRequest) {
            SearchRequest searchRequest = (SearchRequest)request;
            if (searchRequest.source() != null && searchRequest.source().aggregations() != null) {
                for (AggregationBuilder factory : searchRequest.source().aggregations().getAggregatorFactories()) {
                    if (!(factory instanceof TermsAggregationBuilder) || ((TermsAggregationBuilder)factory).minDocCount() != 0L) continue;
                    return SyncAuthorizationFilter.Result.DENIED.reason("min_doc_count 0 is not supported when DLS is activated");
                }
            }
            if (evaluatedDlsFlsConfig.hasFieldMasking() && searchRequest.source() != null && searchRequest.source().aggregations() != null) {
                for (AggregationBuilder aggregationBuilder : searchRequest.source().aggregations().getAggregatorFactories()) {
                    if (aggregationBuilder instanceof TermsAggregationBuilder) {
                        ((TermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                    }
                    if (aggregationBuilder instanceof SignificantTermsAggregationBuilder) {
                        ((SignificantTermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                    }
                    if (!(aggregationBuilder instanceof DiversifiedAggregationBuilder)) continue;
                    ((DiversifiedAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                }
            }
            if (this.localHashingEnabled && !evaluatedDlsFlsConfig.hasFls() && !evaluatedDlsFlsConfig.hasDls() && searchRequest.source().aggregations() != null) {
                boolean cacheable = true;
                for (AggregationBuilder af : searchRequest.source().aggregations().getAggregatorFactories()) {
                    if (af.getType().equals("cardinality") || af.getType().equals("count")) continue;
                    cacheable = false;
                    break;
                }
                if (!cacheable) {
                    searchRequest.requestCache(Boolean.FALSE);
                }
            } else {
                searchRequest.requestCache(Boolean.FALSE);
            }
        }
        if (evaluatedDlsFlsConfig.hasDls() && request instanceof SearchRequest && (source = ((SearchRequest)request).source()) != null && source.profile()) {
            return SyncAuthorizationFilter.Result.DENIED.reason("Profiling is not supported when DLS is activated");
        }
        if (doFilterLevelDls && filteredDlsFlsConfig.hasDls()) {
            return DlsFilterLevelActionHandler.handle(action, request, listener, evaluatedDlsFlsConfig, resolved, this.nodeClient, this.clusterService, this.guiceDependencies.getIndicesService(), this.resolver, this.dlsQueryParser, this.threadContext);
        }
        return SyncAuthorizationFilter.Result.OK;
    }

    private void blockAccessInCaseOfRoleOrMappingsConfigurationErrors() {
        DlsFlsProcessedConfig dlsFlsProcessedConfig = this.config.get();
        if (dlsFlsProcessedConfig != null && dlsFlsProcessedConfig.containsValidationError()) {
            log.error(dlsFlsProcessedConfig.getValidationErrorDescription());
            String msg = "Incorrect configuration of SearchGuard roles or roles mapping, please check the log file for more details. (" + dlsFlsProcessedConfig.getUniqueValidationErrorToken() + ")";
            throw new ElasticsearchStatusException(msg, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    private void setDlsHeaders(EvaluatedDlsFlsConfig dlsFls, ActionRequest request) {
        if (!dlsFls.getDlsQueriesByIndex().isEmpty()) {
            Map<String, Set<String>> dlsQueries = dlsFls.getDlsQueriesByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest((ThreadContext)this.threadContext)) {
                this.threadContext.addResponseHeader("_sg_dls_query", Base64Helper.serializeObject((Serializable)((Serializable)((Object)dlsQueries))));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for DLS info: {}", dlsQueries);
                }
            } else if (this.threadContext.getHeader("_sg_dls_query") != null) {
                Serializable deserializedDlsQueries = Base64Helper.deserializeObject((String)this.threadContext.getHeader("_sg_dls_query"));
                if (!dlsQueries.equals(deserializedDlsQueries)) {
                    throw new ElasticsearchSecurityException("_sg_dls_query does not match (SG 900D)", new Object[0]);
                }
            } else {
                this.threadContext.putHeader("_sg_dls_query", Base64Helper.serializeObject((Serializable)((Serializable)((Object)dlsQueries))));
                if (log.isDebugEnabled()) {
                    log.debug("attach DLS info: {}", dlsQueries);
                }
            }
        }
    }

    private void setDlsModeHeader(Mode mode) {
        String modeString = mode.name();
        if (this.threadContext.getHeader("_sg_dls_mode") != null) {
            if (!modeString.equals(this.threadContext.getHeader("_sg_dls_mode"))) {
                log.warn("Cannot update DLS mode to " + (Object)((Object)mode) + "; current: " + this.threadContext.getHeader("_sg_dls_mode"));
            }
        } else {
            this.threadContext.putHeader("_sg_dls_mode", modeString);
        }
    }

    private Mode getDlsModeHeader() {
        String modeString = this.threadContext.getHeader("_sg_dls_mode");
        if (modeString != null) {
            return Mode.valueOf(modeString);
        }
        return null;
    }

    private void setFlsHeaders(EvaluatedDlsFlsConfig dlsFls, ActionRequest request) {
        if (!dlsFls.getFieldMaskingByIndex().isEmpty()) {
            Map<String, Set<String>> maskedFieldsMap = dlsFls.getFieldMaskingByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest((ThreadContext)this.threadContext)) {
                this.threadContext.addResponseHeader("_sg_masked_fields", Base64Helper.serializeObject((Serializable)((Serializable)((Object)maskedFieldsMap))));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for masked fields info: {}", maskedFieldsMap);
                }
            } else if (this.threadContext.getHeader("_sg_masked_fields") != null) {
                if (!maskedFieldsMap.equals(Base64Helper.deserializeObject((String)this.threadContext.getHeader("_sg_masked_fields")))) {
                    throw new ElasticsearchSecurityException("_sg_masked_fields does not match (SG 901D)", new Object[0]);
                }
                if (log.isDebugEnabled()) {
                    log.debug("_sg_masked_fields already set");
                }
            } else {
                this.threadContext.putHeader("_sg_masked_fields", Base64Helper.serializeObject((Serializable)((Serializable)((Object)maskedFieldsMap))));
                if (log.isDebugEnabled()) {
                    log.debug("attach masked fields info: {}", maskedFieldsMap);
                }
            }
        }
        if (!dlsFls.getFlsByIndex().isEmpty()) {
            Map<String, Set<String>> flsFields = dlsFls.getFlsByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest((ThreadContext)this.threadContext)) {
                this.threadContext.addResponseHeader("_sg_fls_fields", Base64Helper.serializeObject((Serializable)((Serializable)((Object)flsFields))));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for FLS info: {}", flsFields);
                }
            } else if (this.threadContext.getHeader("_sg_fls_fields") != null) {
                if (!flsFields.equals(Base64Helper.deserializeObject((String)this.threadContext.getHeader("_sg_fls_fields")))) {
                    throw new ElasticsearchSecurityException("_sg_fls_fields does not match (SG 901D) " + flsFields + "---" + Base64Helper.deserializeObject((String)this.threadContext.getHeader("_sg_fls_fields")), new Object[0]);
                }
                if (log.isDebugEnabled()) {
                    log.debug("_sg_fls_fields already set");
                }
            } else {
                this.threadContext.putHeader("_sg_fls_fields", Base64Helper.serializeObject((Serializable)((Serializable)((Object)flsFields))));
                if (log.isDebugEnabled()) {
                    log.debug("attach FLS info: {}", flsFields);
                }
            }
        }
    }

    public DlsQueryParser getDlsQueryParser() {
        return this.dlsQueryParser;
    }

    public static enum Mode {
        ADAPTIVE,
        LUCENE_LEVEL,
        FILTER_LEVEL;


        static Mode get(Settings settings) {
            String modeString = settings.get("searchguard.dls.mode");
            if ("adaptive".equalsIgnoreCase(modeString)) {
                return ADAPTIVE;
            }
            if ("lucene_level".equalsIgnoreCase(modeString)) {
                return LUCENE_LEVEL;
            }
            if ("filter_level".equalsIgnoreCase(modeString)) {
                return FILTER_LEVEL;
            }
            return ADAPTIVE;
        }
    }
}

